package editor;

import java.awt.Graphics;

import game.CustomImageDataII;
import game.IntRect;

public abstract class PaletteObject {
	
	protected IntRect clickRect;
	protected boolean isSelected;
	
	protected int distanceToBorder;
	protected int borderWidth;
	
	protected RoomEditorPanel editorPanel;
	
	protected CustomImageDataII image;
	
	
	public IntRect getClickRect() {
		return clickRect;
	}
	
	public abstract void draw(Graphics g);

	public boolean isSelected() {
		return isSelected;
	}

	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}
	
	public CustomImageDataII getImage() {
		return image;
	}
	
	
	
}
